@extends('layouts.admin')

@section('content')
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Create New Permission</h1>
        <p>Define a new system permission</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Permission Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.permissions.store') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">Permission Name</label>
                    <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Enter a unique name for this permission (e.g., "create-users", "edit-posts")</div>
                </div>

                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Create Permission</button>
                    <a href="{{ route('admin.permissions') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection